@echo off
Title Windows Time Control Panel (Geutebrueck GmbH) 

:: Configures the PDC Emulator in the root of a forest to be an authoritative time server
:: and sync time from several NTP time servers on the Internet
:: Info gathered from KB816042 How to configure an authoritative time server in
:: Windows Server 2003 (http://support.microsoft.com/kb/816042)
 
:: On a PDC Emulator the settings changed from the default settings are:
:: Type (From NT5DS to NTP)
:: AnnounceFlags (From 10 to 5)
:: NTPServer (From time.windows.com,0x1 to contents of strTimeServers)
:: SpecialPollInterval (From 3600 to 900)
:: MaxPosPhaseCorrection (From 4294967295 to 1800)
:: MaxNegPhaseCorrection (From 4294967295 to 1800)
 
:: A useful command line command is:
:: w32tm /config /manualpeerlist:"time-a.nist.gov time-b.nist.gov time.nist.gov time-nw.nist.gov" /syncfromflags:manual /reliable:yes /update
:: This command sets AnnounceFlags to 5, NTPServer to the server list and Type to NTP
:: Command found here:
:: http://technet2.microsoft.com/windowsserver/en/library/ce8890cf-ef46-4931-8e4a-2fc5b4ddb0471033.mspx?mfr=true
 
:: A list of the NIST time server can be found here:
:: http://tf.nist.gov/service/time-servers.html
 
:: Microsoft's list of (S)NTP servers is here:
:: http://support.microsoft.com/kb/262680/en-us 






REM Mod 13.03.2013

COLOR 1F
rem color 1A
mode con: cols=140 
echo.

:: Get windows Version numbers
For /f "tokens=2 delims=[]" %%G in ('ver') Do (set _version=%%G) 
For /f "tokens=2,3,4 delims=. " %%G in ('echo %_version%') Do (set _major=%%G& set _minor=%%H& set _build=%%I) 
rem Echo Major version: %_major%  Minor Version: %_minor%.%_build%
if "%_major%"=="5" goto menu

REM check UAC 
dism>NUL
If %errorlevel% NEQ 0 GOTO :INFO
SET NTPSERVERNAME=0

:menu1
cls
call :text
echo.
::echo      
echo. 
echo      Ŀ  Ŀ  Ŀ
echo                                                                                  
echo                                                                                  
echo       [1]=Enable Time Client    [2]=Enable Time Server         [3]=Tools         
echo                                                                                  
echo                                                                                  
echo          
echo.      
::echo      
echo.
Set /P sel="Please select the Option [1],[2],[3] and press ENTER -->"
For %%a In (1, 2, 3) Do if %sel%==%%a Goto SELECT_%%a
echo SELECT ERROR !
pause>NUL
goto menu1




:SELECT_1
cls
call :text
echo.
echo      
echo. 
echo      Ŀ 
echo                               
echo                                
echo       [1]=Enable Time Client   
echo                                
echo                                
echo        
echo.      
echo      
echo.
rem echo Current Parameters:
rem w32tm /dumpreg /subkey:TimeProviders\NtpClient
echo.
echo.
set /P NTPSERVERNAME= Enter Your NTP Server Name or IP-Adress:
echo.
SET /P UpdateIntervalSeconds=Updateinterval (sec.):
SET NTPSERVERS=%NTPSERVERNAME%,0x1
call :status
call :FIREWALL
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NTPClient /v Enabled /t REG_DWORD /d "1" /f 
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NTPServer /v Enabled /t REG_DWORD /d "0" /f 
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NtpClient /v SpecialPollInterval /t REG_DWORD /d %UpdateIntervalSeconds% /f
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\Parameters /v NtpServer /d "%NTPSERVERS%" /f
:: Normally already the default, but just in case:
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\Parameters /v Type /d "NTP" /f
echo ----- Update -----
w32tm /config /update
rem net stop w32time
net start w32time
echo ----- Resync -----
w32tm /resync
echo -----  Status ----
w32tm /query /status
echo -----  Source ----
w32tm /query /source
echo ----- Peers -----
w32tm /query /peers
echo.
echo Press any key back to menu...
pause>NUL
GOTO :menu1


:SELECT_2
cls
echo. 
echo      Ŀ  
echo                                
echo                                
echo       [2]=Enable Time Server   
echo                                
echo                                
echo        
echo.      
rem server setting
echo Setting to Time Server and set local CMOS Clock ...
echo Current parameters NtpServer:
w32tm /dumpreg /subkey:TimeProviders\NtpServer
pause
call :status
call :FIREWALL
net stop w32time
w32tm /config /reliable:yes
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NTPClient /v Enabled /t REG_DWORD /d "0" /f 
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\TimeProviders\NTPServer /v Enabled /t REG_DWORD /d "1" /f 
reg add HKLM\SYSTEM\CurrentControlSet\Services\W32Time\Config /v AnnounceFlags /t REG_DWORD /d "5" /f 
echo ----- Update -----
net start w32time


echo -----  Source ----
w32tm /query /source
echo Press any key back to menu...
pause>NUL
GOTO :menu1


:SELECT_3
echo      Ŀ   
echo                                                                      
echo         [4] = Resync                                              
echo                                                                   
echo         [5] = REG Information                                     
echo                                                                   
echo         [6] = Monitor                                             
echo                                                                   
echo         [7] = RESTORE DEFAULT                                     
echo                                                                   
echo         [8] = Status                                              
echo                                                                   
echo         [9] = w32tm /?                                            
echo                                                                   
echo      
echo.
Set /P sel2="SELECT -->"
echo.
For %%a In (4,5,6,7,8,9) Do if %sel2%==%%a Goto SELECT_%%a
echo SELECT ERROR !
pause>NUL
goto menu



:SELECT_4

rem manuel time sync
w32tm /resync 
echo.
echo Press any key back to menu...
pause>NUL
GOTO :menu1

:SELECT_5
cls
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\w32time\Parameters]
w32tm /dumpreg /subkey:Parameters
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\w32time\Config]
w32tm /dumpreg /subkey:config
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\w32time\TimeProviders\NtpClient]
w32tm /dumpreg /subkey:TimeProviders\NtpClient
echo [HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\w32time\TimeProviders\NtpServer]
w32tm /dumpreg /subkey:TimeProviders\NtpServer




echo.
echo Press any key back to menu...
pause>NUL
GOTO :menu1

:SELECT_6
echo Display Offset between this computer and NtpServer
if %NTPSERVERNAME% == 0 set /P NTPSERVERNAME=Enter NtpServer:

start w32tm /stripchart /computer:%NTPSERVERNAME% 
echo.
echo Press any key back to  menu...

GOTO :menu1

:SELECT_7
rem restore default
net stop w32time
rem MS (w32tm error) muss einfach ignoriert werden! 
w32tm /unregister
w32tm /register
net start w32time
echo.
echo Press any key  back to menu...
pause>NUL
GOTO :menu1

:SELECT_8
w32tm /query /status
echo.
echo Press any key back to  menu...
pause>NUL
GOTO :menu1




:SELECT_9
rem w32tm help
w32tm
echo.
echo Press any key back to  menu...
pause>NUL
GOTO :menu1

:TEXT

for /f "tokens=4"** %%b in ('sc query W32time ^|find "STATE "') do set Status=%%b
cls
echo.
echo      Windows Time Control Panel
echo.                    
echo      Ŀ 
echo          Maintains date and time synchronization on all clients and servers in the network.          
echo          If this service is stopped, date and time synchronization will be unavailable.              
echo          If this service is disabled, any services that explicitly depend on it will fail to start.  
echo      
echo.
echo      Computer Name: [%USERDOMAIN%]     Windows Time Service: [%Status%]
exit /b

:STATUS
echo Configuration windows time service
echo.
for /f "tokens=4"** %%b in ('sc query W32time ^|find "STATE "') do set Status=%%b
echo.
echo [Debug] Status W32Time service: %Status%
echo.

if /i "%Status%" == "STOPPED" call :SERVICETIME

exit /b


:FIREWALL
echo Port sharing for Windows Time Service UDP 123 in
echo Port sharing for Windows Time Service UDP 123 out
netsh advfirewall firewall add rule name="Time Server IN" dir=in action=allow description="NTP 123 IN" enable=yes profile=any localport=123 remoteport=any protocol=UDP>NUL
netsh advfirewall firewall add rule name="Time Server OUT" dir=out action=allow description="NTP 123 OUT" enable=no profile=any localport=123 remoteport=any protocol=UDP>NUL
exit /b

:SERVICETIME
rem config and start time service
sc qc w32time
sc config w32time start= auto
rem sc start w32time
sc qtriggerinfo w32time
SC triggerinfo w32time delete
net stop w32time
net start w32time
exit /b

:INFO
title Warrning!
mode con: cols=100 lines=10
color C
echo.
echo.
echo  *** WARRNING!
echo.
echo.
echo  You may need to launch an elevated Command Prompt (right-ckick Run as administrator) 
echo.
echo.                     
echo.
echo.
pause>NUL
echo.





